	function Poly = POLYSUB(P1, P2)
	
	%	Subtracts two polynomials, P1 - P2, of the form 
	%	An*s^n + An-1*s^n-1+,,,+ a0
 
	% 	Toolbox for  DIGITAL FILTERS USING MATLAB 
	
	%	Author: 		Lars Wanhammar 1983-03-15
	%	Modified by: 	LW 2007-07-12
	%	Copyright:		by authors - not released for commercial use
	%	Version:		1	 
	%	Known bugs:		 
	%	Report bugs to:	Wanhammar@gmail.com
 
	n1 = length(P1);
	n2 = length(P2);
	Poly = zeros(1, max(n1, n2));
	if n1 >= n2
		Poly = P1;
		j = n2:-1:1;
		Poly(n1-n2+j) = Poly(n1-n2+j) - P2(j);
	else
		Poly = -P2;
		j = n1:-1:1;
		Poly(n2-n1+j) = Poly(n2-n1+j) + P1(j);
	end
	
